IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 SYS.TABLES 
	WHERE 
		NAME = 'EST_PROD_TBL_COMIS_PRC_FILIAL' )
BEGIN
SET ANSI_NULLS ON


SET QUOTED_IDENTIFIER ON

CREATE TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL](
	[CD_EMP] [INT] NOT NULL,
	[CD_TBL_COMIS] [INT] NOT NULL,
	[CD_FILIAL] [INT] NOT NULL,
	[PERC_COMIS] [MONEY] NOT NULL,
 CONSTRAINT [PK_EST_PROD_TBL_COMIS_PRC_FILIAL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_TBL_COMIS] ASC,
	[CD_FILIAL] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



ALTER TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_FILIAL_EST_PROD_TBL_COMIS] FOREIGN KEY([CD_EMP], [CD_TBL_COMIS])
REFERENCES [DBO].[EST_PROD_TBL_COMIS] ([CD_EMP], [CD_TBL_COMIS])
ON UPDATE CASCADE
ON DELETE CASCADE


ALTER TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_FILIAL_EST_PROD_TBL_COMIS]


ALTER TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_FILIAL_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
REFERENCES [DBO].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])
ON UPDATE CASCADE


ALTER TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_FILIAL_PRC_FILIAL]


ALTER TABLE [DBO].[EST_PROD_TBL_COMIS_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_PRC_FILIAL_PERC_COMIS]  DEFAULT ((0)) FOR [PERC_COMIS]

END